package parallelsummers;
import summers.SummerThread;
import worker.WorkPartitioner;
import java.util.ArrayList;
import java.util.List;
public class ParallelSummer0{
    public static long sum(int[] data, int threadCount) {
        // List to store instances of SummerThread for parallel processing
        List<SummerThread> summers =  new ArrayList<>();
        // List to store work partitions for each thread
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        // Create SummerThread instances for each work partition
        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerThread(data,part));
        }
        // Start each SummerThread to run in parallel
        for (SummerThread summerThread : summers) {
            summerThread.start();
        }
        // Wait for each thread to complete its execution
        for (SummerThread summerThread : summers) {
            try {
                summerThread.join();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }
        // Aggregate the results from each thread
        int sum = 0;
        for (SummerThread summerThread : summers) {
            sum += summerThread.getSum();
        }
        // Return the final sum calculated in parallel
        return sum;
    }
}
