package parallelsummers;
import summers.SummerCallable;
import worker.WorkPartitioner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
public class ParallelSummer3 {
    public static long sum(int[] data, int threadCount) {
        // Create a fixed thread pool with the specified thread count
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        // List to store instances of SummerCallable for parallel processing
        List<SummerCallable> summers =  new ArrayList<SummerCallable>();
        // List to store work partitions for each thread
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        // Create SummerCallable instances for each work partition
        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerCallable(data,part));
        }
        List<Future<Long>> results;
        // Invoke all SummerCallable tasks and store the Future objects
        try {
            results = executor.invokeAll(summers);
        } catch (InterruptedException e) {
            System.err.println("Cannot invoke the threads.");
            return -1;
        }
        // Shutdown the executor to no longer accept new tasks
        executor.shutdown();
        // Calculate the total sum by summing up individual thread sums
        long sum = 0;
        for (Future<Long> future : results) {
            try {
                // Retrieve and add the result from each thread
                sum += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        // Return the final sum calculated in parallel
        return sum;
    }

}