package parallelsummers;
import summers.SummerThread;
import worker.WorkPartitioner;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
public class ParallelSummer2{

    public static long sum(int[] data, int threadCount) {
        // List to store instances of SummerThread for parallel processing
        List<SummerThread> summers =  new ArrayList<>();
        // List to store work partitions for each thread
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        // Create SummerThread instances for each work partition
        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerThread(data,part));
        }
        // Create a fixed thread pool with the specified thread count
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        // Submit each SummerThread to the executor for parallel execution
        for (SummerThread summer: summers) {
            executor.execute(summer);
        }
        // Shutdown the executor to no longer accept new tasks
        executor.shutdown();
        // Wait for all submitted tasks to complete
        while (!executor.isTerminated()) {
        }
        // Calculate the total sum by summing up individual thread sums
        return summers.stream().mapToLong(SummerThread::getSum).sum();
    }
}
