package parallelsummers;
import summers.SummerRunnable;
import worker.WorkPartitioner;
import java.util.ArrayList;
import java.util.List;
public class ParallelSummer1 {
    public static long sum(int[] data, int threadCount) {
        // List to store instances of SummerRunnable for parallel processing
        List<SummerRunnable> summers =  new ArrayList<>();
        // List to store work partitions for each thread
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        // Create SummerRunnable instances for each work partition
        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerRunnable(data,part));
        }
        // Start each SummerRunnable to run in parallel
        for (SummerRunnable SummerRunnable : summers) {
            SummerRunnable.startThread();
        }
        // Wait for each thread to complete its execution
        for (SummerRunnable SummerRunnable : summers) {
            try {
                SummerRunnable.joinThread();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }
        // Aggregate the results from each thread
        long sum = 0;
        for (SummerRunnable summerRunnable : summers) {
            sum += summerRunnable.getSum();
        }
        // Return the final sum calculated in parallel
        return sum;
    }
}