package org.example;

public class SequentialSummer {
    public static long sum(int[] data) {
        long sum = 0;
        for (int i = 1; i < data.length; i++) {
            if (isPrime(i)) {
                sum ++;
            }
        }
        return sum;
    }
    // Private method to check if a number is prime
    private static boolean isPrime(int num) {
        // Check if the number is less than or equal to 1 (not prime)
        if (num <= 1) {
            return false;
        }
        // Check for some small prime numbers
        if (num <= 3) {
            return true;
        }
        // Check divisibility by 2 or 3
        if (num % 2 == 0 || num % 3 == 0) {
            return false;
        }
        // Check divisibility by numbers of the form 6k ± 1
        for (int i = 5; i * i <= num; i += 6) {
            if (num % i == 0 || num % (i + 2) == 0) {
                return false;
            }
        }
        return true;
    }
}
