package worker;
// Abstract class representing a generic worker for parallel processing
public abstract class Worker {
    // Protected variables to store the start and finish indices and the data array
    protected final int start;
    protected final int finish;
    protected final int[] data;
    // Constructor taking data, start, and finish indices
    public Worker(int[] data, int start, int finish) {
        this.start = start;
        this.finish = finish;
        this.data = data;
    }
    // Constructor taking data and a WorkPartitioner.Part to extract start and finish indices
    public Worker(int[] data, WorkPartitioner.Part part) {

        this(data, part.getStart(), part.getFinish());
    }
    // Getter method to retrieve the start index
    public int getStart() {
        return start;
    }
    // Getter method to retrieve the finish index
    public int getFinish() {
        return finish;
    }
    // Getter method to retrieve the data array
    public int[] getData() {
        return data;
    }


}
