import java.util.ArrayList;
import java.util.List;
import junit.

public class Test {
    public static void main(String[] args) {
        List<Integer> primes = new ArrayList<>();
        List<Thread> threads = new ArrayList<>();
        int numberOfThreads = 12;
        int maxNumber = 100000000;

        long startTime = System.currentTimeMillis();

        for (int i = 0; i < numberOfThreads; i++) {
            int start = i * (maxNumber / numberOfThreads);
            int end = (i + 1) * (maxNumber / numberOfThreads) - 1;

            Thread thread = new Thread(() -> extractPrimes(primes, start, end));
            thread.start();
            threads.add(thread);
        }

        for (Thread thread : threads) {
            try {
                thread.join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        // Main function handling the results from the four functions
        // (e.g., printing or further processing)
        handleResults(primes);

        long endTime = System.currentTimeMillis();

        long executionTime = endTime - startTime;

        System.out.println("Execution time: " + executionTime + " ms");
    }

    private static void extractPrimes(List<Integer> primes, int start, int end) {
        for (int i = start; i <= end; i++) {
            if (isPrime(i)) {
                synchronized (primes) {
                    primes.add(i);
                }
            }
        }
    }

    private static boolean isPrime(int n) {
        if (n <= 1) return false;

        for (int i = 2; i <= Math.sqrt(n); i++) {
            if (n % i == 0) return false;
        }

        return true;
    }

    private static void handleResults(List<Integer> primes) {
        // Handle the results here (e.g., print or further processing)
        System.out.println("Total prime numbers found: " + primes.size());
    }
}

//Total prime numbers found: 5761455
// 5 ->  Execution time: 30488 ms
// 6 ->  Execution time: 28246 ms
// 7 ->  Execution time: 25785 ms
// 8 ->  Execution time: 24829 ms
// 9 ->  Execution time: 24711 ms
// 10->  Execution time: 24343 ms
// 11->  Execution time: 24898 ms
// 12->  Execution time: 25859 ms

