#include <stdio.h>
#include <omp.h>

static long num_steps = 100000;
double step;

int main() {
    int i;
    double x, sum = 0.0;
    double start_time, end_time;

    step = 1.0 / (double)num_steps;

    // Measure execution time of the computation
    start_time = omp_get_wtime();

    #pragma omp parallel for private(x) reduction(+:sum) schedule(static) num_threads(4)
    for (i = 0; i < num_steps; i++) {
        x = (i + 0.5) * step;
        sum += x * x * step;
    }

    end_time = omp_get_wtime();

    printf("Value of the integral is: %f\n", sum);
    printf("Computation execution time: %f seconds\n", end_time - start_time);

    return 0;
}
