 #include <stdio.h>
#include <mpi.h>

static long num_steps = 100000;
double step;

int main(int argc, char *argv[]) {
    int rank, size;
    double local_sum = 0.0;
    double total_sum = 0.0;
    double start_time, end_time;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int local_num_steps = num_steps / size;
    step = 1.0 / (double)num_steps;

    // Measure execution time of the computation
    MPI_Barrier(MPI_COMM_WORLD);
    start_time = MPI_Wtime();

    for (int i = rank * local_num_steps; i < (rank + 1) * local_num_steps; i++) {
        double x = (i + 0.5) * step;
        local_sum += x * x * step;
    }

    end_time = MPI_Wtime();

    // Reduce local sums to obtain the total sum
    MPI_Reduce(&local_sum, &total_sum, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);

    if (rank == 0) {
        printf("The value of the definite integral is: %f\n", total_sum);
        printf("Computation execution time: %f seconds\n", end_time - start_time);
    }

    MPI_Finalize();
    return 0;
}

 
