 
#include <stdio.h>
#include <mpi.h>

#define NUM_RECTANGLES 1000 // Number of rectangles for integration

double calculate_area(double x) {
    return x * x;
}

int main(int argc, char *argv[]) {
    int rank, size;
    double start = 0.0;
    double end = 1.0;
    double total_area = 0.0;
    double width = (end - start) / NUM_RECTANGLES;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    double start_time = MPI_Wtime();
    
    // Each process computes its partial area
    double partial_area = 0.0;
    for (int i = rank; i < NUM_RECTANGLES; i += size) {
        double x = (i + 0.5) * width;
        partial_area += calculate_area(x);
    }

    // Sum up the partial areas across all processes
    MPI_Reduce(&partial_area, &total_area, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);

    // Only the root process prints the result
    if (rank == 0) {
    
        double end_time = MPI_Wtime();
        double execution_time = end_time - start_time;
        total_area *= width;
        printf("Total area under the curve: %lf\n", total_area);
        printf("Execution time: %f\n", execution_time);
    }

    MPI_Finalize();

    return 0;
}
