#include <stdio.h>
#include <omp.h>

#define NUM_THREADS 4
#define NUM_RECTANGLES 1000 // Number of rectangles for integration

double calculate_area(double x) {
    return x * x;
}

int main() {
    double start = 0.0;
    double end = 1.0;
    double total_area = 0.0;
    double width =(end - start) / NUM_RECTANGLES;
    double start_time = omp_get_wtime();
    #pragma omp parallel num_threads(NUM_THREADS)
    {
        int tid = omp_get_thread_num();
        double partial_area = 0.0;

        #pragma omp for
        for (int i = 0; i < NUM_RECTANGLES; i++) {
            double x = (i + 0.5) * width;
            partial_area += calculate_area(x);
        }
        printf("Partial area computed by thread %d is: %f \n",tid,partial_area);
        #pragma omp critical
        total_area += partial_area;
        #pragma omp barrier
    }
    double end_time = omp_get_wtime();
    total_area *= width;
    double execution_time = end_time - start_time;
    printf("Total area under the curve: %lf\n", total_area);
    printf("Execution time: %lf seconds\n", execution_time);
    return 0;
}
