package ThreadPool;

import java.util.ArrayList;
import java.util.List;

public class ThreadPool {
    private MyBlockingQueue<Runnable> taskQueue = null;
    private List<PoolThreadRunnable> runnables = new ArrayList<>();
    private boolean isStopped = false;

    public ThreadPool(int noOfThreads, int maxNoOfTasks) {
        taskQueue = new MyBlockingQueue<Runnable>(maxNoOfTasks);

        for (int i = 0; i < noOfThreads; i++) {
            PoolThreadRunnable poolThreadRunnable = new PoolThreadRunnable(taskQueue);
            runnables.add(poolThreadRunnable);
        }

        for (PoolThreadRunnable runnable : runnables) {
            new Thread(runnable).start();
        }
    }

    public void execute(Runnable task) throws Exception {
        synchronized (this) {
            if (this.isStopped) {
                throw new IllegalStateException("ThreadPool is stopped");
            }
        }
        this.taskQueue.add(task);
    }

    public void stop() {
        synchronized (this) {
            this.isStopped = true;
        }
        for (PoolThreadRunnable runnable : runnables) {
            runnable.doStop();
        }
    }

    public void waitUntilAllTasksFinished(long timeOut) {
        long endTime = System.currentTimeMillis() + timeOut;
        for (PoolThreadRunnable runnable : runnables) {
            try {
                while (!runnable.isStopped()) {
                    long remainingTime = endTime - System.currentTimeMillis();
                    if (remainingTime <= 0) {
                        runnable.doStop();
                        break;
                    }
                    Thread.sleep(Math.min(remainingTime, 100));
                }
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}
