package ThreadPool;

import java.util.ArrayList;
import java.util.List;

public class MyBlockingQueue<T> {
    private List<T> queue = new ArrayList<>();
    private int capacity;

    public MyBlockingQueue(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void add(T item) {
        while (queue.size() == capacity) {
            try {
                wait();
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        queue.add(item);
        notifyAll();
    }

    public synchronized T take() {
        while (queue.isEmpty()) {
            try {
                wait();
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        T item = queue.remove(0);
        notifyAll();
        return item;
    }

    public synchronized int size() {
        return queue.size();
    }
}
