package parallelCounters;
import counters.CounterCallable;
import summers.SummerCallable;
import worker.WorkPartitioner;
import worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

//this class calculates the number of primes in [0 , size-1]
// using ExecutorService with fixed thread pool of threadCount threads,
// and with CounterCallable which implements the Callable interface, by using submit function

public class ParallelCounter4 {

    public static long primesCount(int[] data, int threadCount) {

        //creating a pool of 5 threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        //the result that returning from call function in callable is returned as a type Future
        // because the submit function doesn't wait until the task completes, so the executor service can't return the
        //callable directly, instead it returns the result type Future, which can be retrieved later
        List<Future<Long>> results = new ArrayList<Future<Long>>();

        //partitioning the data to assign each part to a counter to calculate the number of primes
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        //assigning each part to counter callable
        for (Part part : parts) {
            results.add(executor.submit(new CounterCallable(data, part)));
        }

        //waiting until the current thread finishing its work and then shutting it down
        executor.shutdown();

        while (!executor.isTerminated()) {
            //System.out.println("Processing...");
        }

        long count = 0;

        for (Future<Long> future : results) {
            try {
                count += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }

        return count;
    }


}
