package parallelCounters;

import counters.CounterRunnable;
import counters.CounterThread;
import summers.SummerRunnable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;



//this class calculates the number of primes in [0 , size-1] using CounterRunnable which implements the Runnable Interface

public class ParallelCounter1 {
    public static long primesCount(int[] data, int threadCount) {

        List<CounterRunnable> counters =  new ArrayList<>();

        //partitioning the data to assign each part to a counter to calculate the number of primes
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        //assigning each part to counter runnable
        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterRunnable(data,part));
        }

        //starting the threads
        for (CounterRunnable counterRunnable : counters) {
            counterRunnable.startThread();
        }

        for (CounterRunnable counterRunnable : counters) {
            try {
                counterRunnable.joinThread();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        //defining a variable to hold the total number of primes
        long count = 0;
        for (CounterRunnable counterRunnable : counters) {
            count += counterRunnable.getCount();
        }

        return count;
    }




}
