package counters;
import java.util.ArrayList;
import java.util.List;


import PrimerFinder.PrimerFinder;
import worker.WorkPartitioner.Part;

public class CounterThread extends Thread{
	private int start;
	private int finish;
	private int[] data;
	private long count;
	
	public CounterThread(int[] data, int start, int finish) {
		this.start = start;
		this.finish = finish;
		this.data = data;
	}

	public CounterThread(int[] data, Part part) {
	    this(data, part.getStart(), part.getFinish());
	}

	@Override
	public void run() {
		count = 0;
		List<Integer> primes=new ArrayList<>();
		PrimerFinder primerFinder=new PrimerFinder(start,finish,primes);
		for (int i = start; i < finish; i++) {
			if (primerFinder.isPrime(i)) {
				synchronized (primerFinder.getPrimeNumList()) {
					primerFinder.getPrimeNumList().add(i);
					count++;
				}
			}
		}
	}

	public long getCount() {
		return count;
	}
	
}