package parallelCounters;

import summers.SummerRunnable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;




public class ParallelCounter1 {

    public static long sum(int[] data, int threadCount) {

        List<SummerRunnable> summers =  new ArrayList<>();
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerRunnable(data,part));
        }

        for (SummerRunnable SummerRunnable : summers) {
            SummerRunnable.startThread();
        }

        for (SummerRunnable SummerRunnable : summers) {
            try {
                SummerRunnable.joinThread();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        long sum = 0;
        for (SummerRunnable summerRunnable : summers) {
            sum += summerRunnable.getSum();
        }

        return sum;
    }


}
