package parallelSummers;


import java.util.ArrayList;
import java.util.List;


import counters.CounterThread;
import summers.SummerThread;
import worker.WorkPartitioner;
import worker.WorkPartitioner.Part;


public class ParallelSummer0 {

	public static long primesCount(int[] data, int threadCount) {

		List<CounterThread> counters =  new ArrayList<>();
		List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
		for (Part part : parts) {
			counters.add(new CounterThread(data,part));
		}
		for (CounterThread counterThread : counters) {
			counterThread.start();
		}

		for (CounterThread counterThread : counters) {
			try {
				counterThread.join();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}

		int count = 0;
		for (CounterThread counterThread : counters) {
			count += counterThread.getCount();
		}

		return count;
	}

	public static long sum(int[] data, int threadCount) {
		
		List<SummerThread> summers =  new ArrayList<>();
		List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
		
		for (Part part : parts) {
			summers.add(new SummerThread(data,part));
		}
		
		for (SummerThread summerThread : summers) {
			summerThread.start();
		}
		
		for (SummerThread summerThread : summers) {
			try {
				summerThread.join();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}
		
	    
	    int sum = 0;
	    for (SummerThread summerThread : summers) {
			sum += summerThread.getSum();
		}

	    return sum;
	}

	
}
