package parallelCounters;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


import PrimerFinder.PrimerFinder;
import counters.CounterThread;
import summers.SummerThread;
import worker.WorkPartitioner;
import worker.WorkPartitioner.Part;


public class ParallelCounter0{

    public static long primesCount(int[] data, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        for (Part part : parts) {
            counters.add(new CounterThread(data,part));
        }
        for (CounterThread counterThread : counters) {
            counterThread.start();
        }

        for (CounterThread counterThread : counters) {
            try {
                counterThread.join();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        long count = 0;
        for (CounterThread counterThread : counters) {
            count += counterThread.getCount();
        }

        return count;
    }

}
