package parallelCounters;
import summers.SummerCallable;
import worker.WorkPartitioner;
import worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;



public class ParallelCounter4 {

    public static long sum(int[] data, int threadCount) {

        //creating a pool of 5 threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        List<Future<Long>> results = new ArrayList<Future<Long>>();
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        for (Part part : parts) {
            results.add(executor.submit(new SummerCallable(data, part)));
        }

        executor.shutdown();

        while (!executor.isTerminated()) {
            //System.out.println("Processing...");
        }

        long sum = 0;
        for (Future<Long> future : results) {
            try {
                sum += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }

        return sum;
    }


}
