package parallelCounters;


import summers.SummerThread;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class ParallelCounter2{

    public static long sum(int[] data, int threadCount) {

        List<SummerThread> summers =  new ArrayList<>();
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        for (WorkPartitioner.Part part : parts) {
            summers.add(new SummerThread(data,part));
        }

        //creating a pool of 5 threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        for (SummerThread summer: summers) {
            executor.execute(summer);
        }

        executor.shutdown();

        //Waiting for all the thread to finalize
        while (!executor.isTerminated()) {
            //System.out.println("Processing....");
        }

        return summers.stream().mapToLong(SummerThread::getSum).sum();
    }


}
