package fiftyShadesOfMultiThreading.parallelSummers;


import java.util.ArrayList;
import java.util.List;

import fiftyShadesOfMultiThreading.summers.SummerThread;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;


public class ParallelSummer0 {

	public static long sum(int[] data, int threadCount) {
		
		List<SummerThread> summers =  new ArrayList<>();
		List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
		
		for (Part part : parts) {
			summers.add(new SummerThread(data,part));
		}
		
		for (SummerThread summerThread : summers) {
			summerThread.start();
		}
		
		for (SummerThread summerThread : summers) {
			try {
				summerThread.join();
			} catch (InterruptedException e) {
				System.err.println("Thread cannot join!");
			}
		}
		
	    
	    int sum = 0;
	    for (SummerThread summerThread : summers) {
			sum += summerThread.getSum();
		}

	    return sum;
	}

	
}
