package fiftyShadesOfMultiThreading.parallelCounters;



import fiftyShadesOfMultiThreading.counters.CounterThread;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

//this class calculates the number of primes in [0 , size-1]
// using ExecutorService with fixed thread pool of threadCount threads, and with counter thread
public class ParallelCounter2{
    public static long primesCount(int[] data, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();

        //partitioning the data to assign each part to a counter to calculate the number of primes
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        //assigning each part to counter thread
        for (Part part : parts) {
            counters.add(new CounterThread(data,part));
        }

        //defining an executor with fixed thread pool to make each thread calculates a number of primes in its own part
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        //executing the threads
        for (CounterThread counter : counters) {
            executor.execute(counter);
        }
        //waiting until the current thread finishing its work and then shutting it down
        executor.shutdown();
        //Waiting for all the thread to finalize
        while (!executor.isTerminated()) {
            //System.out.println("Processing....");
        }

        //returning the total number of primes
        return counters.stream().mapToLong(CounterThread::getCount).sum();

    }
}
