package fiftyShadesOfMultiThreading.parallelCounters;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


import fiftyShadesOfMultiThreading.PrimerFinder.PrimerFinder;
import fiftyShadesOfMultiThreading.counters.CounterThread;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;

//this class calculates the number of primes in [0 , size-1] using CounterThread

public class ParallelCounter0{

    public static long primesCount(int[] data, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();

        //partitioning the data to assign each part to a counter to calculate the number of primes
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        //assigning each part to counter thread
        for (Part part : parts) {
            counters.add(new CounterThread(data,part));
        }

        //starting threads to calculate the number of primes
        for (CounterThread counterThread : counters) {
            counterThread.start();
        }

        for (CounterThread counterThread : counters) {
            try {
                counterThread.join();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        //defining a variable to hold the total number of primes
        long count = 0;
        for (CounterThread counterThread : counters) {
            count += counterThread.getCount();
        }

        return count;
    }

}
