package parallelCounters;


import counters.CounterRunnable;
import counters.CounterThread;
import summers.SummerThread;
import worker.WorkPartitioner;
import worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


public class ParallelCounter2{
    public static long primesCount(int[] data, int threadCount) {

        List<CounterThread> counters =  new ArrayList<>();
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        for (Part part : parts) {
            counters.add(new CounterThread(data,part));
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        for (CounterThread counter : counters) {
            executor.execute(counter);
        }
        executor.shutdown();
        //Waiting for all the thread to finalize
        while (!executor.isTerminated()) {
            //System.out.println("Processing....");
        }

        return counters.stream().mapToLong(CounterThread::getCount).sum();

    }
}
