package parallelCounters;

import counters.CounterRunnable;
import counters.CounterThread;
import summers.SummerRunnable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;




public class ParallelCounter1 {
    public static long primesCount(int[] data, int threadCount) {

        List<CounterRunnable> counters =  new ArrayList<>();
        List<WorkPartitioner.Part> parts =  WorkPartitioner.partitions(data.length, threadCount);
        for (WorkPartitioner.Part part : parts) {
            counters.add(new CounterRunnable(data,part));
        }
        for (CounterRunnable counterRunnable : counters) {
            counterRunnable.startThread();
        }

        for (CounterRunnable counterRunnable : counters) {
            try {
                counterRunnable.joinThread();
            } catch (InterruptedException e) {
                System.err.println("Thread cannot join!");
            }
        }

        long count = 0;
        for (CounterRunnable counterRunnable : counters) {
            count += counterRunnable.getCount();
        }

        return count;
    }




}
