package parallelCounters;
import counters.CounterCallable;
import summers.SummerCallable;
import worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import worker.WorkPartitioner.Part;


public class ParallelCounter3 {

    public static long primesCount(int[] data, int threadCount) {

        //creating a pool of #threadCount threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        List<CounterCallable> counters =  new ArrayList<CounterCallable>();
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        for (Part part : parts) {
            counters.add(new CounterCallable(data,part));
        }

        List<Future<Long>> results;
        try {
            results = executor.invokeAll(counters);
        } catch (InterruptedException e) {
            System.err.println("Cannot invoke the threads.");
            return -1;
        }

        executor.shutdown();

        long count = 0;
        for (Future<Long> future : results) {
            try {
                count += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        return count;
    }

}
