package fiftyShadesOfMultiThreading.parallelCounters;

import fiftyShadesOfMultiThreading.counters.CounterCallable;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;

//this class calculates the number of primes in [0 , size-1]
// using ExecutorService with fixed thread pool of threadCount threads,
// and with CounterCallable which implements the Callable interface, by invoking all callables

public class ParallelCounter3 {

    public static long primesCount(int[] data, int threadCount) {

        //creating a fixed pool of threadCount threads
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);

        List<CounterCallable> counters =  new ArrayList<CounterCallable>();

        //partitioning the data to assign each part to a counter to calculate the number of primes
        List<Part> parts =  WorkPartitioner.partitions(data.length, threadCount);

        //assigning each part to counter callable
        for (Part part : parts) {
            counters.add(new CounterCallable(data,part));
        }

        //the result that returning from call function in callable is returned as a future
        // because the submit function doesn't wait until the task completes, so the executor service can't return the
        //callable directly, instead it returns the result type Future, which can be retrieved later
        List<Future<Long>> results;
        try {
            // the invokeAll function allows us to submit many callables at once, it accepts a collection of callable,
            //and returning a list of futures
            results = executor.invokeAll(counters);
        } catch (InterruptedException e) {
            System.err.println("Cannot invoke the threads.");
            return -1;
        }

        //waiting until the current thread finishing its work and then shutting it down
        executor.shutdown();

        long count = 0;
        for (Future<Long> future : results) {
            try {
                count += future.get();
            } catch (InterruptedException | ExecutionException e) {
                System.err.println("Cannot get the results from threads.");
                return -2;
            }
        }
        return count;
    }

}
