package fiftyShadesOfMultiThreading.counters;
import fiftyShadesOfMultiThreading.PrimerFinder.PrimerFinder;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;



public class CounterCallable extends Counter implements Callable<Long> {

	public CounterCallable(int[] data, Part part) {
		super(data, part);
	}

	@Override
	public Long call() throws Exception {
		count = 0;
		List<Integer> primes = new ArrayList<>();
		PrimerFinder primerFinder = new PrimerFinder(start, finish, primes);
		for (int i = start; i < finish; i++) {
			if (primerFinder.isPrime(i)) {
				synchronized (primerFinder.getPrimeNumList()) {
					primerFinder.getPrimeNumList().add(i);
					count++;
				}
			}
		}
		return count;
	}
}