package fiftyShadesOfMultiThreading;
import fiftyShadesOfMultiThreading.data.TestData;
import org.junit.Test;
import org.junit.jupiter.api.BeforeAll;
import fiftyShadesOfMultiThreading.parallelCounters.*;
import static org.junit.Assert.assertEquals;
import static org.junit.jupiter.api.Assertions.*;

/*import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;*/


    public class TestParallelCounter {
        private static int size;
        private static int[] data;
        private static long result;

        @BeforeAll
        public static void initialize() {
            size = 1000000;
            data = TestData.createData(size);
            result = SequentialCounter.primesCount(data);
        }

        private static void testAll(int threadCount) {
            initialize();
            assertEquals(result, ParallelCounter0.primesCount(data,threadCount));
            System.out.println("parallel counter 0:"+result);
            assertEquals(result, ParallelCounter1.primesCount(data,threadCount));
            System.out.println("parallel counter 1:"+result);
            assertEquals(result, ParallelCounter2.primesCount(data,threadCount));
            System.out.println("parallel counter 2:"+result);
            assertEquals(result, ParallelCounter3.primesCount(data,threadCount));
            System.out.println("parallel counter 3:"+result);
            assertEquals(result, ParallelCounter4.primesCount(data,threadCount));
            System.out.println("parallel counter 4:"+result);
        }

        @Test
        public void testSingleThread() {
            testAll(1);
        }

        @Test
        public void testTwoThread() {
            testAll(2);
        }

        @Test
        public void testFourThread() {
            testAll(4);
        }

        @Test
        public void testEightThread() {
            testAll(8);
        }

        @Test
        public void testSixteenThread() {
            testAll(16);
        }


    }

