package fiftyShadesOfMultiThreading.counters;

import fiftyShadesOfMultiThreading.PrimerFinder.PrimerFinder;
import fiftyShadesOfMultiThreading.worker.WorkPartitioner.Part;

import java.util.ArrayList;
import java.util.List;

public class CounterRunnable extends Counter implements Runnable{
    private Thread thread;

    public CounterRunnable(int[] data, Part part) {
        super(data, part);
    }

    @Override
    public void run() {
        count = 0;
        List<Integer> primes=new ArrayList<>();
        PrimerFinder primerFinder=new PrimerFinder(start,finish,primes);
        for (int i = start; i < finish; i++) {
            if (primerFinder.isPrime(i)) {
                synchronized (primerFinder.getPrimeNumList()) {
                    primerFinder.getPrimeNumList().add(i);
                    count++;
                }
            }
        }
    }

    public void startThread() {
        thread =  new Thread(this);
        thread.start();
    }

    public void joinThread() throws InterruptedException {
        thread.join();
    }
}
