package PrimerFinder;

import java.util.ArrayList;
import java.util.List;

public class ParallelPrimerFinder {
    private int numberOfThreads;

    public ParallelPrimerFinder(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }
    public List<Integer> primesFinder(int rangeStart,int rangeEnd) {
        int threadRange = (rangeEnd - rangeStart) / numberOfThreads;

        List<Integer> primes = new ArrayList<>();
        List<Integer> finalPrimes = new ArrayList<>();
        List<PrimerFinder> threads = new ArrayList<>();
        for (int i = 0; i < numberOfThreads ; i++) {
            int start = rangeStart + i * threadRange;
            int end = (i < numberOfThreads - 1) ? start + threadRange : rangeEnd;
            PrimerFinder thread = new PrimerFinder(start, end, primes);
            threads.add(thread);
            thread.start();
        }
        try {
            for (PrimerFinder thread : threads) {
                thread.join();
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        return primes;
    }
}
