public class BinarySearchHackerThread extends Hacker {

    public BinarySearchHackerThread(Vault vault) {
        super(vault);
        this.setName("BinarySearchHackerThread");
        this.setPriority(Thread.MAX_PRIORITY);
    }

    @Override
    public void hack() {
        int low = 0;
        int high = 9999;

        while (low <= high) {
            int mid = (low + high) / 2;
            attempts++;
            if (vault.isCorrectPassword(mid)) {
                System.out.println(this.getName() + " guessed the password.");
                Hacker.printAllAttempts();
                System.exit(0);
            } else if (mid < vault.getSecretCode()) {
                low = mid + 1;
            } else {
                high = mid - 1;
            }
        }
    }
    
}
