import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Hacker extends Thread {
    protected final Vault vault;
    private static final List<Hacker> ALL_HACKERS = Collections.synchronizedList(new ArrayList<>());
    protected int attempts = 0;

    public Hacker(Vault vault) {
        this.vault = vault;
        ALL_HACKERS.add(this);
    }

    public abstract void hack();

    @Override
    public void run() { hack(); }

    public int getAttempts() { return attempts; }

    // helper to print attempts of all hackers
    public static void printAllAttempts() {
        synchronized (ALL_HACKERS) {
            for (Hacker h : ALL_HACKERS) {
                System.out.println(h.getName() + " attempted: " + h.getAttempts() + " times");
            }
        }
    }
}
