import java.util.concurrent.ThreadLocalRandom;

public class Vault {
    private final int secretCode;

    public Vault() {
        this(0, 9999);
    }

    public Vault(int min, int max) {
        if (min > max) throw new IllegalArgumentException("min > max");
        this.secretCode = randBetween(min, max);
        System.out.println("Vault password is set to " + this.secretCode);
    }

    public boolean isCorrectPassword(int guess) {
        try {
            Thread.sleep(5);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.secretCode == guess;
    }

    public int getSecretCode() {
        return secretCode;
    }

    private static int randBetween(int min, int max) {
        if (min > max) throw new IllegalArgumentException("min > max");
        if (max == Integer.MAX_VALUE) {
            return (int) ThreadLocalRandom.current().nextLong(min, (long) max + 1L);
        }
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }
}