import java.util.Random;

class VaultHackingRace {

    static class Vault {
        private final int password;

        public Vault() {
            this.password = new Random().nextInt(10000);
            System.out.println("Vault created with password: " + this.password);
        }

        public boolean isCorrectPassword(int guess) {
            try {
                Thread.sleep(5);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            return guess == this.password;
        }
    }

    abstract static class HackerThread extends Thread {
        protected Vault vault;

        public HackerThread(Vault vault) {
            this.vault = vault;
            this.setName(this.getClass().getSimpleName());
            this.setPriority(Thread.MAX_PRIORITY);
        }

        @Override
        public void start() {
            System.out.println(this.getName() + " started working");
            super.start();
        }
    }

    static class AscendingHackerThread extends HackerThread {
        public AscendingHackerThread(Vault vault) {
            super(vault);
        }

        @Override
        public void run() {
            for (int guess = 0; guess <= 9999; guess++) {
                if (vault.isCorrectPassword(guess)) {
                    System.out.println(this.getName() + " won with password: " + guess);
                    System.exit(0);
                }
            }
        }
    }

    static class DescendingHackerThread extends HackerThread {
        public DescendingHackerThread(Vault vault) {
            super(vault);
        }

        @Override
        public void run() {
            for (int guess = 9999; guess >= 0; guess--) {
                if (vault.isCorrectPassword(guess)) {
                    System.out.println(this.getName() + " won with password: " + guess);
                    System.exit(0);
                }
            }
        }
    }

    static class PoliceThread extends Thread {
        @Override
        public void run() {
            for (int i = 10; i > 0; i--) {
                try {
                    Thread.sleep(1000);
                    System.out.println("Time remaining: " + i + " seconds");
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Game over for you hackers!");
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Vault vault = new Vault();

        AscendingHackerThread ascendingHacker = new AscendingHackerThread(vault);
        DescendingHackerThread descendingHacker = new DescendingHackerThread(vault);
        PoliceThread police = new PoliceThread();

        ascendingHacker.start();
        descendingHacker.start();
        police.start();
    }
}