
# MPI Prefix Sum and Tree-Based Reduction

This project includes two parallel algorithms implemented using **MPI**: 

1. **Prefix Sum**: A parallel implementation of the prefix sum (also known as the cumulative sum) of an array of integers.
2. **Tree-Based Reduction**: A custom MPI reduction operation, where the sum of an array is calculated using a tree structure for efficient communication.

## Requirements

- **Python 3.x**: The program is implemented in Python.
- **mpi4py**: A Python package for MPI bindings.
  
  You can install the required package by running:

  ```bash
  pip install mpi4py
  ```

- **MPI Implementation**: You need an MPI implementation (e.g., OpenMPI or MPICH) installed on your system.

## Algorithms

### 1. Prefix Sum (Parallel)

In this part of the project, each process calculates a portion of the prefix sum. The algorithm is divided into three stages:

- **Step 1 (Parallel)**: The array is divided into blocks, and the prefix sum for each block is computed in parallel.
- **Step 2 (Sequential)**: The prefix sums of the blocks are calculated in a sequential manner to prepare for the next stage.
- **Step 3 (Parallel)**: The final prefix sum is computed for each block by adding the result of the sequential step to each element within the block.

The prefix sum is computed by each process, and the root process (Rank 0) gathers the final result.

### 2. Tree-Based Reduction

This algorithm performs a custom tree-based reduction operation (addition) to combine the data across all processes. It is executed as follows:

- **Step 1**: Each process starts with its local data.
- **Step 2 (Tree-Based)**: Each process exchanges its data with its partner and combines them. This is done in a tree structure where data is exchanged and combined progressively.
- **Step 3 (Final Reduction)**: The root process (Rank 0) receives all the data and completes the final reduction.


## Notes

- **Prefix Sum**:
  - The program implements the prefix sum calculation using a parallel approach that splits the work into blocks and performs the final sum efficiently.
  - The result is gathered by the root process, which outputs the final prefix sum array.

- **Tree-Based Reduction**:
  - This implementation customizes the `MPI_Reduce` operation using a tree-based method to combine data.
- Make sure to run the program with multiple processes using `mpirun` for parallel execution.

## License

This project is open source and available under the MIT License.

