


package medicalanalysis.program;

import medicalanalysis.program.DataCollect.DataLoader;
import medicalanalysis.program.DataCollect.Patient;
import medicalanalysis.program.DataCollect.History;
import medicalanalysis.program.DataCollect.Feature;
import medicalanalysis.program.Similarity.EcliudDistance;
import medicalanalysis.program.Similarity.ManhatenDistance;
import medicalanalysis.program.Similarity.MinkoDistance;
import java.util.Scanner;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.InvocationTargetException;
import medicalanalysis.program.Similarity.Distancable;

/**
 *
 * @author HASAN
 * 
*/
public class Program {
  
    
    //static variable :
    
    public static Scanner myObj = new Scanner(System.in);
    public static Patient userData = new Patient ();
    public static int k =10;
    public static  History history=new History();
    public static String file = new String ("");   
    public static  String grade =new String();
    public static Distancable similarity =new EcliudDistance();   
    

  
 public static void main(String[] args)throws Exception {
    
     connectToFile();// try to connect to the file and  load the file data  
    
     
     ReadPatientData(userData); // read the patient tests 
  
     setKTH();
     
     choseDistance();// chose the type of the distance minkowski ,ecuild or manhaten 
  
     Predictor newPrediction  = new Predictor(k,userData,history ,similarity);//the main algorithm of prediction
        
     grade=newPrediction.getPrecidt();// get the predict
     
     System.out.println(" the result is : "+grade);
     
  /*  */  
    }
 private static  void connectToFile(){
     
        
        
     System.out.println("Enter the File Path ");
     file =myObj.nextLine();
     try {
         
        history=DataLoader.dataloader(file);//try to load the data 
     }
        
     catch(IOException e  )/*catch the faild of file open */{
            
        System.out.println("uncorrect file path ,\nEnter e backup file or re write the file name   ");
        String backup =new String("default_file_path.txt ");
        backup =myObj.nextLine();
        
        try{
                 history=DataLoader.dataloader(backup); 
        }
        
        catch(IOException e1 ){
            
            System.out.println("un correct file and backup ,  ");
          
            System.exit(0);
        }
        
            
        }
    finally{//finally we should to close the file connection
            
       // System.out.println(" the file connection colsed ");
                 
            
        }
                
     
        
    }
 private static void choseDistance(){
        
       System.out.println("-Enter \n1- to Eculidane Distance \n2- to Minko Distance \n3- to Manhaten Distance  ");
       
        String value =myObj.nextLine();
        switch(value){
            case "1" : similarity =new EcliudDistance ()  ;  break ; 
            case "2" : similarity =new MinkoDistance ()   ; break ; 
            default : similarity =new  ManhatenDistance ()  ;  break ; 
            
            
        }
         
        
        
    }
 private static void setKTH(){
      
     System.out.println("-\nEtner the K th :");
     try{
         k=Integer.parseInt(myObj.nextLine());
         
         if(k>history.getPatients().size()||k<=0||k%2==0){
             System.out.println("the K is more than the size of data");
             k=1;
             
         }
     }catch(NumberFormatException e ){
         System.out.println("-\nuncorrect value to  the K th :");
         k=1;
     }
     
 }
 public static void ReadPatientData(Patient p ){
        
    for (int i=0;i<history.getType().size();i++){
        // read data ==>>X
        System.out.println("Enter test "+history.getTestName(i)+" value :");

        String userData = myObj.nextLine();  // Read user input
      
        try{
            Feature f =new Feature(history.getType(i),userData);
            p.add(f);
            
        }catch(Exception e ){
                
            System.out.println(userData+" is Invalid data reEnter the number ");
            i--;
                
        }
    }
        
        
}

    
}


