/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package medicalanalysis.program.DataCollect;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;


/**
 *
 * @author HASASN
 */
public class Feature <T> {
    
    private T value;//the value of the analysis 
    
    /*used this function to create an instance from Feautre for  type(className)and set the value */
    public static Feature<?> creatInstance(String className, String value)
            throws NoSuchMethodException ,ClassNotFoundException,InstantiationException
                                        ,IllegalAccessException,InvocationTargetException
    {
        
        
        Class c=Class.forName(className);
        Constructor v=c.getConstructor(String.class);
       
        
       Feature<?>g=new Feature( v.newInstance(value));
                
        return g;
        
    }
  
    public Double getMeasure(){
        String type=value.getClass().getName();
        
       
        switch(type){
            case"java.lang.String":return new Double(((String)value).length());
            
            case"java.lang.Boolean":return ((Boolean)value)?1.0:0.0;
            
            default :{
                
                 String t=value.getClass().getGenericSuperclass().getTypeName();
                if(t.equalsIgnoreCase("java.lang.Number")){
                    
                    return ((Number)value).doubleValue();
                }else{
                    
                    return new Double((value.toString()).length());
                    
                }
                
            }
            
        }
        
        
    }
    
    public Feature(String className, String value)
            throws NoSuchMethodException ,ClassNotFoundException,InstantiationException
                                         ,IllegalAccessException,InvocationTargetException
    {
        
        Class clazz=Class.forName(className);
        Constructor cons=clazz.getConstructor(String.class);
        this.value=(T)( cons.newInstance(value));
        
        
    }
    public Feature(T value) {
        this.value = value;
    }
    public void setValue(T value) {
        this.value = value;
    }
    public T getValue() {
        return value;
    }
    
    @Override
    public String toString() {
        return  value.toString() ;
    }

    
}
