

package medicalanalysis.program.DataCollect;

import medicalanalysis.program.DataCollect.Patient;
import medicalanalysis.program.DataCollect.History;
import medicalanalysis.program.DataException.NotCompleteDataException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import java.util.StringTokenizer;
import java.util.ArrayList;
import java.io.IOException;
import java.lang.Class;
import java.lang.reflect.Constructor;
import java.lang.ClassNotFoundException;
import java.lang.reflect.InvocationTargetException;


/**
 *
 * @author HASAN
 * 
*/

public class DataLoader {
    
    public static History  dataloader(String path )throws IOException{
        
        History Sample=new History ();
        try  {
           BufferedReader br = new BufferedReader(new FileReader(path)) ;
           String line;
           
           line=br.readLine();
           
           readTestNames(line,Sample);
           
           readFieldType(line,Sample);
           
           int dataLength =Sample.getType().size()+1;
           
         
           while ((line = br.readLine()) != null) {
           
               Patient p ;
               try {
        
                   p=PatientLoader(line,dataLength,Sample);
                  
                   if(p!=null){
                       
                       Sample.setPatients(p);
                       
                   }
                 
               }
               catch(NotCompleteDataException e1 ){
                   System.out.println("\nInvalid Data  in line : "+line);
                   System.out.println("the line length is : "+line.length());
                   System.out.println("the error is : "+e1.getLocalizedMessage());
                   
                   
        
               }
               
               
            }
           System.out.println("the data loaded from the file   ");
         
        }catch(IOException e){
         
            // throw the ioexception to the upper function 
            // because in the current level we cannot do any thing 
            
            throw e ;
         
        }catch(Exception e )/*in case happend an eception we not expect it */{
              System.out.println(e.getMessage());
              
        }
       finally {
         // finally if the file found or not 
         // we should close the connection
         
         //sbr.close();
         System.out.println("the  file connection closed  ");
                 
            
        
                 }
        
       
        return Sample;
    }
    
    public static Patient PatientLoader(String values,int l ,History s )throws NotCompleteDataException ,ClassNotFoundException ,Exception/*change it */ {
        Patient p =new Patient ();

        ArrayList<String>data =new ArrayList();

        data=(split(values,","));

        
        if(data.size()==l){
            
            for(int i =0;i<data.size()-1;i++){
              
                String value=data.get(i).replaceAll("\\s", "");
                
                String type=s.getType(i);
                  Feature f;
                // incase the data were  boolean so replace 1 into true and so 
                value=(type.equals("java.lang.Boolean"))? (value.equals("1")||value.equals("true"))?"True":"False" :value;
              
                try{
                  f=new Feature(type,value);//to create an instacne from Featue of Type (type)and Value (value)
                                                  //this function throws exceptions 
                                                  //ClassNotFoundException,InstantiationException,IllegalAccessException,InvocationTargetException
     
               }catch(ClassNotFoundException e1 ){
                   
                  System.out.println("errors occcurs :unKnown Class " +e1.getMessage()+"\n"); 
                  System.out.println("the Class replaced with java.lang.String \n"); 
                  s.setType("java.lang.String",i);
                  type=s.getType(i);
                   f= new Feature(type,value);
                      
                  
               }
               catch(InvocationTargetException e2 ){
                  
                   System.out.println("\nInvalid Data   for constructor \nData is : "+value+"\ntype of data should be :"+type);
                   System.out.println("the line length is : "+l);
                   
                   if(e2.getCause().getClass().getName().equals("java.lang.NumberFormatException")){
                       f= new Feature(type,"0");
                         System.out.println("and replaced with  : 0");
                   
                      
                   }else{
                       return null;
                   }
               
                   
               }
                
               
            
                //   System.out.println(f);
                   
            p.add(f);
            }   
            if(data.get(data.size()-1).toLowerCase().replaceAll("\\s", "").equals("high")|| 
                    data.get(data.size()-1).toLowerCase().replaceAll("\\s", "").equals("low")){
         
            throw new NotCompleteDataException(values,"not complete data ",data.size(),"illegal gread");
                     
        }
            p.setGrade(data.get(data.size()-1).toLowerCase().replaceAll("\\s", ""));
            
         return p;
         
        }else{
            
            throw new NotCompleteDataException(values,"not complete data ",data.size(),"illegal length");
            
        }
        
        
        
        
   
    }
    
    private static void readFieldType(String line,History Sample ){
        ArrayList<String >t =new ArrayList();
        t=split(line,",");
        //set the type of the data for each feature :==>
        for(String i : t){
            Sample.setType("java.lang."+split(i,"&").get(1).replaceAll("\\s", ""));
            
        }
        
        
    }
     
    private static void readTestNames(String line ,History Sample)/*read the test name in the first line of the file */{
        int i=0;
          for(String l : split(line ,",")){
              Sample.addTest( split(l,"&").get(0));
              i++;
              
          }
    }

    public static ArrayList<String> split(String line, String delimiter) {
        ArrayList<String> result = new ArrayList<>();
       
        StringTokenizer st = new StringTokenizer(line, delimiter);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
            
       
        }
    
    return result;
    }
}
