﻿using OpenQA.Selenium;
using OpenQA.Selenium.Support.UI;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Dummy.SeleniumTests.SigninTets.Pages
{
    public class StorePage : IStorePage
    {
        private IWebDriver _driver;
        private WebDriverWait _wait;

        //Locators ( UI Elements)
        private readonly By totalCost = By.Id("cart_total_price");
        private readonly By gst = By.Id("cart_total_sales_tax");
        private readonly By itemRowSelector = By.CssSelector(".billing_item_services");
        
        // item quantity and add button prefixes
        private readonly String itemQuantityPrefix = "quantity-";
        private readonly String itemAddButtonPrefix = "add_service_";


        public StorePage(IWebDriver driver)
        {
            _driver = driver;
            _wait = new WebDriverWait(_driver, TimeSpan.FromSeconds(1));
        }


        public IEnumerable<int> GetItemsCodeList()
        {
            List<int> itemCodes = new ();

            // Find all item rows and extract codes friom them
            var itemRows = _wait.Until(d => d.FindElements(itemRowSelector));
            foreach (IWebElement row in itemRows)
            {
                // Locate the anchor tag within the row
                // // to retrieve the code from its id attribute
                var addButton = row.FindElement(By.XPath(".//td/a[starts-with(@id, 'add_service_')]"));

                string idAttribute = addButton.GetAttribute("id");

                // Extract the code from the id attribute,  like add_service_33 ===> 33
                if (int.TryParse(idAttribute.Split('_').Last(), out int code))
                {
                    itemCodes.Add(code);
                }
            }

            return itemCodes;
        }


        public int? FirstItemCode()
        {
            var itemCodes = GetItemsCodeList();
            return itemCodes.Any() ? itemCodes.First() : (int?)null;
        }
        public int? GetLastItemCode()
        {
            var itemCodes = GetItemsCodeList();
            return itemCodes.Any() ? itemCodes.Last() : (int?)null;
        }


        public void SetItemQuantity(int quantity,int code )
        {
            var selectItem =_wait.Until(d => d.FindElement(By.Id(itemQuantityPrefix + code)));

            selectItem.SendKeys(quantity.ToString());


        }


        public void AddItem(int code)
        {
         var addButton=   _wait.Until(d => d.FindElement(By.Id(itemAddButtonPrefix + code)));
            addButton.Click();
        }

        public int CalculateFee(int itemCode,int quantity)
        {
            
            int fee = GetFee(itemCode);
            
            return (quantity *  (fee))/10;
        }


        public int GetGSt()
        {
           var gstAmount= _wait.Until(d => d.FindElement(gst));

            return parseCurrency(gstAmount.Text);
        }

        public int GetFee(int itemCode )
        {
            // XPath to locate the row containing the specific item code in the anchor tah
            string feeXPath = $"//tr[td/a[@id='add_service_{itemCode}']]/td[3]";

            var fee = _wait.Until(d => d.FindElement(By.XPath(feeXPath)));

            return  parseCurrency(fee.Text) ;
        }

        public int GetTotal()
        {
            var totalAmount = _wait.Until(d => d.FindElement(totalCost));

            return parseCurrency(totalAmount.Text);
        }
        private int parseCurrency(string currencyText)
        {
            return int.TryParse(currencyText.Replace("A$", "").Replace(",", "").Trim(), out int result) ? result : 0;
        }


    }
}
