﻿using Dummy.SeleniumTests.SigninTets.Pages;
using NUnit.Framework;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;

namespace Dummy.SeleniumTests.SigninTets.Tests
{
    public class StoreTest
    {
        public StorePage _storePage;
        public SigninPage _siginPage;

        private IWebDriver _driver;

        //
        public String HostName = "https://whenwise.agileway.net/biz/wise-pool/store";
        public String LoginHostName = "https://whenwise.agileway.net/sign-in";


        [SetUp]
        public void SetUp()
        {
            _driver = new ChromeDriver();
            _driver.Navigate().GoToUrl(LoginHostName);
            _siginPage = new SigninPage(_driver);

            _siginPage.EnterUserName("james@client.com");
            _siginPage.EnterPassword("test01");

            _siginPage.Submit();

            _driver.Navigate().GoToUrl(HostName);
            _storePage = new StorePage(_driver);
        }

        [Test]
        public void TestCartStore()
        {
            int qty = 10;
            
            int fcode=_storePage.FirstItemCode();
            
            _storePage.SetItemQuantity(qty,fcode);

            _storePage.AddItem(fcode);

            int tfee = _storePage.calculateFee(_storePage.firstItemFee, 10);

            int itemPrice = _storePage.GetFee(_storePage.firstItemFee);

            string actualTotal = _storePage.GetTotal();
            string actualGST = _storePage.GetGSt();

            Assert.IsTrue(actualGST.Equals("A$"+tfee+".00"));
            Assert.IsTrue(actualTotal.Equals("A$"+tfee+qty*itemPrice+".00"));

        }

        [TearDown]
        public void TearDown()
        {

        }
    }
}
