﻿using OpenQA.Selenium;
using OpenQA.Selenium.Support.UI;
using System;

namespace Dummy.SeleniumTests.SigninTets.Pages
{
    public class StorePage
    {
        private IWebDriver _driver;
        private WebDriverWait _wait;

        //Locators ( UI Elements)
        private By totalCost = By.Id("cart_total_price");
        private By gst = By.Id("cart_total_sales_tax");
        
        public String firstItemFee = "//*[@id=\"store_cart_products\"]/tbody/tr[1]/td[3]";
        public String secondItemFee = "//*[@id=\"store_cart_products\"]/tbody/tr[2]/td[3]";

        private String itemQuantity = "quantity-";
        private String itemAddButton = "add_service_";

        


        public int FirstItemCode()
        {
            return 41;
        }
        public int SecondItemCode()
        {
            return 33;
        }

        public StorePage(IWebDriver driver)
        {
            _driver = driver;
            _wait = new WebDriverWait(_driver, TimeSpan.FromSeconds(10));
        }

        public void SetItemQuantity(int quantity,int code )
        {
            var selectList =_wait.Until(d => d.FindElement(By.Id(itemQuantity + code)));
            selectList.SendKeys(""+quantity);

        }
        public void SetFirstItemQuantity(int quantity)
        {
            SetItemQuantity(quantity,SecondItemCode());
        }
        public void SetSecondItemQuantity(int quantity)
        {
            SetItemQuantity(quantity, FirstItemCode());
        }

        public void AddItem(int code)
        {
         var addButton=   _wait.Until(d => d.FindElement(By.Id(itemAddButton + code)));
            addButton.Click();
        }

        public int calculateFee(string feeXPath,int quantity)
        {
            int fee= GetFee(feeXPath);
            
            return (quantity *  (fee))/10;
        }


        public string GetGSt()
        {
           var gstAmount= _wait.Until(d => d.FindElement(gst));

            return gstAmount.Text;
        }

        public int GetFee(String feeXPath )
        {
            var fee = _wait.Until(d => d.FindElement(By.XPath(feeXPath)));

            return  Int32.Parse(fee.Text.Split("$")[2]) ;
        }

        public string GetTotal()
        {
            var totalAmount = _wait.Until(d => d.FindElement(totalCost));

            return totalAmount.Text;
        }



    }

}
