﻿using OpenQA.Selenium;
using OpenQA.Selenium.Support.UI;
using System;

namespace Dummy.SeleniumTests.SigninTets.Pages
{
    public class SigninPage
    {
        private IWebDriver _driver;
        private WebDriverWait _wait;

        //Locators ( UI Elements)
        private By usernameField = By.Id("email");
        private By passwordField = By.Id("password");
        private By loginButton = By.Id("login-btn");


        public SigninPage(IWebDriver driver)
        {
            _driver = driver;
            _wait = new WebDriverWait(_driver, TimeSpan.FromSeconds(10));
        }


        public void EnterUserName(string username)
        {
            var usernameF = _wait.Until(d => d.FindElement(usernameField));
            usernameF.SendKeys(username);
        }
        public void EnterPassword(string pass)
        {
            var passwordF = _wait.Until(d => d.FindElement(passwordField));
            passwordF.SendKeys(pass);
        }
        public void Submit()
        {
            var submitButton = _wait.Until(d => d.FindElement(loginButton));
            submitButton.Click();
        }
    }

}
