﻿using Dummy.Console;
using NUnit.Framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Dummy.Tests
{   
    [TestFixture]
    public class DegreeConverterTests
    {
        private DegreeConverter _degreeConverter;

        [SetUp]
        public void SetUp()
        {
            _degreeConverter = new DegreeConverter();

        }

        [TestCase(0,32)]
        [TestCase(5, 41)]
        [TestCase(10, 50)]
        public void ToFahrenheit_celicusDegree_returnCorrectValue(double celcuisDegree , double expectedValue)
        {


            
            // Act 
            double actual = _degreeConverter.ToFahrenheit(celcuisDegree);

            // Fact 

            Assert.AreEqual(expectedValue , actual);


        }
        [Test]
        public void ToFahrenheit_passZero_32()
        {
            // Arrange 
            double expected = 32;
            double testValue = 0;

            
            // Act 
            double actual = _degreeConverter.ToFahrenheit(testValue);

            // Fact 

            Assert.AreEqual(expected, actual);


        }

        [Test]
        [TestCase(5,0)]
        [TestCase(52, 0)]
        [TestCase(15, 0)]
        public void deivde_tozero_throwsArithmeticException(double nominator , double denominator)
        {
            //Assert
            Assert.Throws<ArithmeticException>(() => _degreeConverter.devide(nominator, denominator));
        }


        [TestCase(10, 2,5)]
        [TestCase(60, 30,2)]
        [TestCase(30, 15,2)]
        public void deivde_tononZero_returnExpectedResult(double nominator, double denominator, double actual)
        {
            double result = _degreeConverter.devide(nominator, denominator);

            //Assert
            Assert.AreEqual(result,actual);
        }




    }
}
