﻿using NUnit.Framework;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Dummy.SeleniumTests
{
    public class LoginTest
    {
        private const string password = "SuperSecretPassword!";
        private const string userName = "tomsmith";
        private const string hostName = "https://the-internet.herokuapp.com/login";

        [Test]
        public void SignIn_ShouldBe_Successfull()
        {
            // create the driver 
            var driver = new ChromeDriver();
            
            // navigate to the url
            driver
                .Navigate()
                .GoToUrl(hostName);

            // get the email input button 
            IWebElement emailInput = driver.FindElement(By.Name("username"));
            
            // get the password input button
            IWebElement passswordInput = driver.FindElement(By.Name("password"));

            // enter the user name and password 
            emailInput.SendKeys(userName);
            passswordInput.SendKeys(password);
    
            // get the login form 
            IWebElement form = driver.FindElement(By.Id("login"));

            // submit the form 
            form.Submit();

            String url = driver.Url;
            Assert.IsTrue(url.Contains("secure"));

            // close the browser after finishing 
            driver.Close();
        }
    }

}
