﻿using System.Collections.Generic;

namespace Dummy.SeleniumTests.SigninTets.Pages
{
    public interface IStorePage
    {
        /// <summary>
        /// this function return a list of the codes of the items in the shop
        /// </summary>
        /// <returns>List of int represent the items code</returns>
        public IEnumerable<int> GetItemsCodeList();

        /// <summary>
        /// returns the code of the first item in the shop
        /// </summary>
        /// <returns>an integer represent the code of the first item or null if no items are available</returns>
        public int? FirstItemCode();

        /// <summary>
        /// returns the code of the last item in the shop
        /// </summary>
        /// <returns>an integer represent the code of the last item or null if no items are available</returns>
        public int? GetLastItemCode();

        /// <summary>
        /// set the quantity for a specific item in the shop
        /// </summary>
        /// <param name="quantity">rhe desired quantity to set for the item</param>
        /// <param name="code">the code of the item for which the quantity will be sets</param>
        public void SetItemQuantity(int quantity, int code);

        /// <summary>
        /// add an  item to the cart
        /// </summary>
        /// <param name="code">the code of the item to add it to the cart</param>
        public void AddItem(int code);

        /// <summary>
        /// calculates the total fee for a given item based on it s code and the quantity
        /// </summary>
        /// <param name="itemCode">the code of the item</param>
        /// <param name="quantity">the quantity of the item</param>
        /// <returns>the calculated total fee as an integer</returns>
        public int CalculateFee(int itemCode, int quantity);

        /// <summary>
        /// retrieves the GST amount for the cart
        /// </summary>
        /// <returns>The GST amount as an integer</returns>
        public int GetGSt();

        /// <summary>
        /// gets the fee of a specific item by its code
        /// </summary>
        /// <param name="itemCode">he code of the item</param>
        /// <returns>the fee of the item as an integer</returns>
        public int GetFee(int itemCode);

        /// <summary>
        /// retrieves the total cost of items in the cart
        /// </summary>
        /// <returns>ش string represent the total cost</returns>
        public int GetTotal();
    }

}
