﻿using Dummy.SeleniumTests.SigninTets.Pages;
using NUnit.Framework;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Dummy.SeleniumTests.ShoppingCartTest.Tests
{
    public class StoreTest
    {
        public IStorePage _storePage;
        public SigninPage _siginPage;

        private IWebDriver _driver;

        //
        public string HostName = "https://whenwise.agileway.net/biz/wise-pool/store";
        public string LoginHostName = "https://whenwise.agileway.net/sign-in";


        [SetUp]
        public void SetUp()
        {
            _driver = new ChromeDriver();
            _driver.Navigate().GoToUrl(LoginHostName);
            _siginPage = new SigninPage(_driver);

            _siginPage.EnterUserName("james@client.com");
            _siginPage.EnterPassword("test01");

            _siginPage.Submit();

            _driver.Navigate().GoToUrl(HostName);
            _storePage = new StorePage(_driver);
        }

        [Test]
        public void GetItemsCodeList_ShouldReturnListOfCodes()
        {
            // Act
            var itemCodes = _storePage.GetItemsCodeList();

            // Assert
            Assert.That(itemCodes, Is.Not.Empty);
            Assert.IsTrue(itemCodes.All(code => code > 0));
        }

        [Test]
        public void TestCartStore_FullScenario()
        {
            int qty = 10;

            int? fcode = _storePage.FirstItemCode();

            Assert.IsTrue(fcode is not null, "the list should conatin an item");

            _storePage.SetItemQuantity(qty, (int)fcode);

            _storePage.AddItem((int)fcode);

            int tfee = _storePage.CalculateFee((int)fcode, 10);

            int itemPrice = _storePage.GetFee((int)fcode);

            int actualTotal = _storePage.GetTotal();
            int actualGST = _storePage.GetGSt();

            Assert.IsTrue(actualGST.Equals(tfee), "GST does not match the expected value");
            Assert.IsTrue(actualTotal.Equals(tfee + qty * itemPrice), "Total cost does not match the expected value");

        }

        [Test]
        public void GetTotal_ShouldReturnCorrectTotalAmount()
        {
            // Acts

            // get item codes list 
            var itemCodes = _storePage.GetItemsCodeList();
            // setting  quantity
            int quantity = 2;

            // get fee 
            int fee = _storePage.GetFee(itemCodes.First());

            // set the quantity
            _storePage.SetItemQuantity(quantity, itemCodes.First());
            // add the item
            _storePage.AddItem(itemCodes.First());

            // the expected total
            int expectedTotal = fee * quantity;
            
            // Assert
            Assert.AreEqual(expectedTotal, _storePage.GetTotal(), "Total amount does not match expected value");
        }

        [Test]
        public void AddItem_ShouldAddItemToCart()
        {
            // Acts
            var itemCodes = _storePage.GetItemsCodeList();
            _storePage.AddItem(itemCodes.First());

            // verify that item has been added by checking the total
            int fee = _storePage.GetFee(itemCodes.First());
            int expectedTotal = fee;

            // Assert
            Assert.AreEqual(expectedTotal, _storePage.GetTotal(), "Total does not match expected value after adding one item");
        }

        [Test]
        public void FirstItemCode_ShouldReturnFirstItemCode()
        {
            var itemCodes = _storePage.GetItemsCodeList();
            var firstItemCode = _storePage.FirstItemCode();
            Assert.AreEqual(itemCodes.FirstOrDefault(), firstItemCode, "First item code does not match the expected value");
        }

        [Test]
        public void GetLastItemCode_ShouldReturnLastItemCode()
        {
            // Acts 
            var itemCodes = _storePage.GetItemsCodeList();
            var lastItemCode = _storePage.GetLastItemCode();
            
            // Assert
            Assert.AreEqual(itemCodes.LastOrDefault(), lastItemCode, "Last item code does not match the expected value");
        }
        [Test]
        public void CalculateFee_ShouldReturnCorrectTotalForQuantity()
        {

            // Acts
            var itemCodes = _storePage.GetItemsCodeList();
            int quantity = 3;

            int fee = _storePage.GetFee(itemCodes.First());
            
            int expectedFee = quantity * fee / 10 ;

            int calculatedFee = _storePage.CalculateFee(itemCodes.First(), quantity);

            // Assert
            Assert.AreEqual(expectedFee, calculatedFee, "Calculated fee does not match expected value");
        }

        [TearDown]
        public void TearDown()
        {
            _driver.Quit();
        }
    }
}
