#!/bin/bash



ip_range=$1
start_ip=$(echo "$ip_range" | cut -d'-' -f1)
end_ip=$(echo "$ip_range" | cut -d'-' -f2)
start=$(echo "$start_ip" | cut -d'.' -f4)
end=$(echo "$end_ip" | cut -d'.' -f4)
if (( start >= 0  && end <= 256 && start <= end ))
then
    for ((n=start; n<=end; n++)); do
        host="192.168.0.$n"
        ping -c2 "$host" &> /dev/null
        if [ $? = 0 ]; then
            echo "$host is UP"
        else
            echo "$host is DOWN"
        fi
    done
else
    echo "incorrect ip range, use the format 192.168.0.startnumber-192.168.0.endnumber"
fi
