#!/bin/bash

# Task 1: Create a new folder in the home directory
mkdir ~/new_folder

# Task 2: Create all possible combinations of files in the new folder
cd ~/new_folder
for i in {1..10}; do
    for j in {a..z}; do
        touch "file${i}_${j}"
    done
done

# Task 3: Append "Hello Linux" to files ending with the letter x
for file in *x; do
    echo "Hello Linux" >> "$file"
done

# Task 4: Create folders for each English letter and move files to the correct folder
for letter in {a..z}; do
    mkdir "$letter"
    mv [a-z]*"$letter" "$letter"
done

# Task 5: Find and delete files containing numbers 3 or 4 in their names
find . -type f -name "*[34]*" -exec rm {} \;
